<?php
namespace VM\FinancialStatementsBundle\Services;

use VM\FinancialStatementsBundle\Services\DataStructure\FinansowanieInwestycjiDS;
use VM\FinancialStatementsBundle\Services\InterfaceFinancialStatements;

class FinansowanieInwestycjiPodsumowanie{

    protected $PodsumowanieWszystkichInwestycji;

    /**
     * @var array
     */
    protected $Inwestycje = [];

    /**
     * @var int
     */
    protected $ileLat = 9;

    /**
     * constructor
     */
    public function __construct()
    {
        $this->buildPodsumowanieWszystkichInwestycji();
    }

    public function addFinansowanieInwestycji(FinansowanieInwestycji $FinansowanieInwestycji)
    {
        $this->evaluateSummary($FinansowanieInwestycji);
    }

    protected function buildPodsumowanieWszystkichInwestycji()
    {
        $pom = new \stdClass(); // pomocnicza zmienna, zeby byla krotsza nazwa

        $pom->amortyzacjaNaRok = array();
        $pom->wartoscPoczatkowaNaRok = array();
        $pom->wartoscKoncowaNaRok = array();
        $pom->zmianaKapitaluObcegoNaRok = array();
        $pom->kosztyFinansoweNaRok = array();
        $pom->zmianaKapitaluWlasnegoNaRok = array();
        $this->PodsumowanieWszystkichInwestycji = $pom;
    }

    protected function evaluateSummary(FinansowanieInwestycji $FinansowanieInwestycji)
    {
        $ileLatInwestycji = $FinansowanieInwestycji->getResultsOf('liczbaLat');
        $poczatekInwestycji = $FinansowanieInwestycji->getRokPoczatkowy();

        $amort = array_fill($poczatekInwestycji, $ileLatInwestycji, 0);
        $wartPoc = array_fill($poczatekInwestycji, $ileLatInwestycji, 0);
        $wartKon = array_fill($poczatekInwestycji, $ileLatInwestycji, 0);
        $zmKapOb = array_fill($poczatekInwestycji, $ileLatInwestycji, 0);
        $kosztFin = array_fill($poczatekInwestycji, $ileLatInwestycji, 0);
        $zmKapWl = array_fill($poczatekInwestycji, $ileLatInwestycji, 0);

        $amortyzacja = $FinansowanieInwestycji->getResultsOf('Amortyzacja');
        $podsumowanie = $FinansowanieInwestycji->getResultsOf('Podsumowanie');

        $amort[$poczatekInwestycji] += $amortyzacja->amortyzacjaNaRok[$poczatekInwestycji];
        $wartPoc[$poczatekInwestycji] += $amortyzacja->wartoscPoczatkowaNaRok[$poczatekInwestycji];
        $wartKon[$poczatekInwestycji] += $amortyzacja->wartoscKoncowaNaRok[$poczatekInwestycji];

        $zmKapOb[$poczatekInwestycji] += $podsumowanie->zmianaKapitaluObcegoNaRok[$poczatekInwestycji];
        $kosztFin[$poczatekInwestycji] += 0;
        $zmKapWl[$poczatekInwestycji] += $podsumowanie->zmianaKapitaluWlasnego;

        for($i = $poczatekInwestycji+1; $i < $poczatekInwestycji + $ileLatInwestycji; $i++)
        {
            $amort[$i] += $amortyzacja->amortyzacjaNaRok[$i];
            $wartPoc[$i] += $amortyzacja->wartoscPoczatkowaNaRok[$i];
            $wartKon[$i] += $amortyzacja->wartoscKoncowaNaRok[$i];

            $zmKapOb[$i] += $podsumowanie->zmianaKapitaluObcegoNaRok[$i];
            $kosztFin[$i] += $podsumowanie->kosztyFinansoweNaRok[$i];
            $zmKapWl[$i] += 0;
        }

        $this->Inwestycje[] = $FinansowanieInwestycji;

        $this->prepareArray($ileLatInwestycji, $poczatekInwestycji);

        for($i = $poczatekInwestycji; $i < $poczatekInwestycji + $ileLatInwestycji; $i++)
        {
            $this->PodsumowanieWszystkichInwestycji->amortyzacjaNaRok[$i] += $amort[$i];
            $this->PodsumowanieWszystkichInwestycji->wartoscPoczatkowaNaRok[$i] += $wartPoc[$i];
            $this->PodsumowanieWszystkichInwestycji->wartoscKoncowaNaRok[$i] += $wartKon[$i];
            $this->PodsumowanieWszystkichInwestycji->zmianaKapitaluObcegoNaRok[$i] += $zmKapOb[$i];
            $this->PodsumowanieWszystkichInwestycji->kosztyFinansoweNaRok[$i] += $kosztFin[$i];
            $this->PodsumowanieWszystkichInwestycji->zmianaKapitaluWlasnegoNaRok[$i] += $zmKapWl[$i];
        }

        unset($this->NoweInwestycje);
    }

    protected function prepareArray($ileLatInwestycji, $poczatekInwestycji)
    {
        for($i = $poczatekInwestycji; $i < $poczatekInwestycji + $ileLatInwestycji; $i++)
        {
            if(!isset($this->PodsumowanieWszystkichInwestycji->amortyzacjaNaRok[$i]))
            {
                $this->PodsumowanieWszystkichInwestycji->amortyzacjaNaRok[$i] = 0;
            }

            if(!isset($this->PodsumowanieWszystkichInwestycji->wartoscPoczatkowaNaRok[$i]))
            {
                $this->PodsumowanieWszystkichInwestycji->wartoscPoczatkowaNaRok[$i] = 0;
            }

            if(!isset($this->PodsumowanieWszystkichInwestycji->wartoscKoncowaNaRok[$i]))
            {
                $this->PodsumowanieWszystkichInwestycji->wartoscKoncowaNaRok[$i] = 0;
            }

            if(!isset($this->PodsumowanieWszystkichInwestycji->zmianaKapitaluObcegoNaRok[$i]))
            {
                $this->PodsumowanieWszystkichInwestycji->zmianaKapitaluObcegoNaRok[$i] = 0;
            }

            if(!isset($this->PodsumowanieWszystkichInwestycji->kosztyFinansoweNaRok[$i]))
            {
                $this->PodsumowanieWszystkichInwestycji->kosztyFinansoweNaRok[$i] = 0;
            }

            if(!isset($this->PodsumowanieWszystkichInwestycji->zmianaKapitaluWlasnegoNaRok[$i]))
            {
                $this->PodsumowanieWszystkichInwestycji->zmianaKapitaluWlasnegoNaRok[$i] = 0;
            }
        }
    }

    public function getPodsumowanieWszystkichInwestycji()
    {
        return $this->PodsumowanieWszystkichInwestycji;
    }

}

?>
